<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'name', 'email', 'phone', 'nic_number', 'passport_number', 'pass_expiry_date', 'type_identification', 'adresse', 'ville', 'status');
    protected $visible = array('slug', 'name', 'email', 'phone', 'nic_number', 'passport_number', 'pass_expiry_date', 'type_identification', 'adresse', 'ville', 'status');

    public function sendings()
    {
        return $this->hasMany('App\Models\Transfer', 'sender_customer_id');
    }

    public function exchanges()
    {
        return $this->hasMany('App\Models\Exchange', 'customer_id');
    }

    public function beneficiarings()
    {
        return $this->hasMany('App\Models\Transfer', 'beneficiary_customer_id');
    }

}